#coding:utf-8
'''
                               ___-------___
                           _-~~             ~~-_
                        _-~                    /~-_
     /^\__/^\         /~  \                   /    \
   /|  O|| O|        /      \_______________/        \
  | |___||__|      /       /                \          \
  |          \    /      /                    \          \
  |   (_______) /______/                        \_________ \
  |         / /         \                      /            \
   \         \^\\         \                  /               \     /
     \         ||           \______________/      _-_       //\__//
       \       ||------_-~~-_ ------------- \ --/~   ~\    || __/
         ~-----||====/~     |==================|       |/~~~~~
          (_(__/  ./     /                    \_\      \.
                 (_(___/       -jurcy-           \_____)_)


Para los dibujos recursivos, es importante identificar la tarea principal que se
realiza al dibujarlo. Por ejemplo, en el tríangulo de sierpinski, la tarea es dibujar
media arista, dibujar un triangulo de sierpinski, continuar la arista, rotar y dibujar
la siguiente arista, hasta que el largo de la arista sea suficientemente pequeño.

En este caso, la tarea es dibujar una linea, rotar x a la izquierda,
dibujar un arbol fractal, rotar x a la derecha, y dibujar otro arbol fractal,
voler a la orientación original, rotar x a la izqueirda, dibujar otro arbol,
voler a la orientación original, y volver a la posición original, hasta que
la linea se lo suficientemente corta.
'''

import turtle

def arbolfractal(angle, length, min_size):
    if length < min_size:
        return
    turtle.forward(length)

    turtle.right(angle)
    arbolfractal(angle, length - 8, min_size)
    turtle.left(angle)


    turtle.left(angle)
    arbolfractal(angle, length - 8, min_size)
    turtle.right(angle)

    turtle.up()
    turtle.backward(length)
    turtle.down()

x = 15 # angulo
l = 100 # largo
min_size = 10 # largo minimo

turtle.up()
turtle.setpos(0, -200)
turtle.down()
min_size = 10
turtle.speed(10)
turtle.screensize(canvwidth=1000, canvheight=1500)

turtle.left(90)
arbolfractal(x, l, min_size)

